{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 11.08.98 - 12:35:47 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  SysUtils,
  Windows,
  Messages,
  Classes,
  Graphics,
  Controls,
  StdCtrls,
  Forms,
  DBCtrls,
  DB,
  Mask,
  ExtCtrls,
  DBTables,
  Buttons,
  Dialogs,
  ComCtrls,
  MMSystem,
  MMWBlob,
  MMObj,
  MMDSPObj,
  MMWave,
  MMACMDlg,
  MMUtils,
  MMCstDlg,
  MMWavOut,
  MMHook,
  MMDesign,
  MMPanel,
  MMConect,
  MMDIBCv,
  MMLevel,
  MMWavIn,
  MMWaveIO, MMWMixer, MMPitch;

type
  TMainForm = class(TForm)
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Table1: TTable;
    Table1Name: TStringField;
    Table1Info: TStringField;
    StatusBar: TStatusBar;
    WaveBlob: TMMWaveBlob;
    OpenDialog: TMMWaveOpenDialog;
    SaveDialog: TMMWaveSaveDialog;
    MMDesigner1: TMMDesigner;
    WaveOut: TMMWaveOut;
    MMPanel1: TMMPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label40: TLabel;
    lblFormat: TLabel;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    btnPause: TBitBtn;
    btnPlay: TBitBtn;
    btnStop: TBitBtn;
    BtnRecord: TBitBtn;
    btnExport: TBitBtn;
    btnImport: TBitBtn;
    MMPanel2: TMMPanel;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMConnector1: TMMConnector;
    WaveIn: TMMWaveIn;
    RecordFile: TMMWaveFile;
    MMConnector2: TMMConnector;
    ACM: TMMACM;
    Table1Voice: TBlobField;
    procedure FormCreate(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure BtnRecordClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure Table1AfterOpen(DataSet: TDataSet);
    procedure btnPauseClick(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure btnExportClick(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    procedure Table1BeforePost(DataSet: TDataSet);
    procedure Table1AfterPost(DataSet: TDataSet);
    procedure Table1AfterCancel(DataSet: TDataSet);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutPause(Sender: TObject);
    procedure WaveOutRestart(Sender: TObject);
    procedure WaveInClose(Sender: TObject);
    procedure WaveInStart(Sender: TObject);
    procedure WaveInStop(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    procedure ShowWaveParams;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
var
   TempFile: array[0..1024] of Char;
begin
    Table1.TableName := ExtractFilePath(Application.ExeName)+'Voices';

    { create a temp file for recordings }
    TempFile[0] := #0;
    wioFileCreateTemp(TempFile);
    RecordFile.Wave.FileName := TempFile;

    Table1.Open;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { close all devices }
   WaveOut.Close;
   WaveIn.Close;
   { delete the temp file }
   SysUtils.DeleteFile(RecordFile.Wave.FileName);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Table1AfterOpen(DataSet: TDataSet);
begin
   btnRecord.Enabled := True;
   btnPlay.Enabled   := not WaveBlob.Wave.Empty;
   btnExport.Enabled := not WaveBlob.Wave.Empty;
   btnImport.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
var
   State: TMMWaveOutState;

begin
   State := WaveOut.State;
   if (wosPause in State) and (wosPlay in State) then
       WaveOut.Restart
   else
       WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.BtnRecordClick(Sender: TObject);
begin
   { select a WaveFormat and start recording }
   if ACM.ChooseFormat(WaveIn.PWaveFormat,'Select Format') then
   begin
      WaveIn.PWaveFormat := ACM.PWaveFormat;
      WaveIn.Start;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
   WaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
begin
   WaveOut.Pause;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.DataSource1DataChange(Sender: TObject; Field: TField);
begin
   { Table changed, make sure the devices are closed }
   WaveOut.Close;
   WaveIn.Stop;

   btnRecord.Enabled := True;
   btnPlay.Enabled   := not WaveBlob.Wave.Empty;
   btnExport.Enabled := not WaveBlob.Wave.Empty;
   btnImport.Enabled := True;
   btnStop.Enabled   := False;
   btnPause.Enabled  := False;

   ShowWaveParams;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnExportClick(Sender: TObject);
begin
   if not WaveBlob.Wave.Empty then
   begin
      if (SaveDialog.Execute) then
      begin
         WaveBlob.Wave.SaveToFile(SaveDialog.Filename);
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnImportClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      WaveBlob.Wave.LoadFromFile(OpenDialog.Filename);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Table1BeforePost(DataSet: TDataSet);
begin
   StatusBar.SimpleText := 'Saving data....';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Table1AfterPost(DataSet: TDataSet);
begin
   StatusBar.SimpleText := 'Finished!';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Table1AfterCancel(DataSet: TDataSet);
begin
   StatusBar.SimpleText := 'Cancelled!';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ShowWaveParams;
var
   FormatTag,Format,Size,Time: String;

begin
   if not WaveBlob.Wave.Empty then
   begin
      Size := '; ' + IntToStr(WaveBlob.Wave.FileSize div 1024) + ' KB';
      Time := TimeToString(WaveBlob.Wave.DataSize);
      acmGetFormatDescription(WaveBlob.Wave.PWaveFormat, FormatTag, Format);
      lblFormat.Caption := FormatTag+'; '+Format+Size+'; '+Time;
   end
   else lblFormat.Caption := '<Empty>';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   { playing started, update some controls }
   btnRecord.Enabled := False;
   btnPlay.Enabled   := False;
   btnStop.Enabled   := True;
   btnPause.Enabled  := True;
   btnExport.Enabled := False;
   btnImport.Enabled := False;
   StatusBar.SimpleText := 'Playing data...';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   { playing stopped, close the device }
   WaveOut.Close;

   btnRecord.Enabled := True;
   btnPlay.Enabled   := not WaveBlob.Wave.Empty;
   btnExport.Enabled := not WaveBlob.Wave.Empty;
   btnImport.Enabled := True;
   btnStop.Enabled   := False;
   btnPause.Enabled  := False;

   StatusBar.SimpleText := 'Playing done!';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutPause(Sender: TObject);
begin
   { playing paused }
   btnPlay.Enabled   := not WaveBlob.Wave.Empty;
   btnPause.Enabled  := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutRestart(Sender: TObject);
begin
   { playing restarted }
   btnPlay.Enabled   := False;
   btnPause.Enabled  := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveInStart(Sender: TObject);
begin
   { recording has started, update some controls }
   btnRecord.Enabled := False;
   btnPlay.Enabled   := False;
   btnStop.Enabled   := True;
   btnPause.Enabled  := False;
   btnExport.Enabled := False;
   btnImport.Enabled := False;

   StatusBar.SimpleText := 'Recording data...';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveInStop(Sender: TObject);
begin
   { recording stopped, close the device }
   WaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveInClose(Sender: TObject);
begin
   { load the recorded file in the Blob }
   if not RecordFile.Wave.Empty then
      WaveBlob.Wave.LoadFromFile(RecordFile.Wave.FileName);

   btnRecord.Enabled := True;
   btnPlay.Enabled   := not WaveBlob.Wave.Empty;
   btnExport.Enabled := not WaveBlob.Wave.Empty;
   btnImport.Enabled := True;
   btnStop.Enabled   := False;
   btnPause.Enabled  := False;

   StatusBar.SimpleText := 'Recording done!';
end;

end.
